/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.javacomm.client.resource.Resource;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.protocol.Userdata;
import net.javacomm.window.manager.Control;
import net.javacomm.window.manager.WindowManagerInternalFrame;



@SuppressWarnings("serial")
public class JUpdateProfilFrame extends WindowManagerInternalFrame {

  public final static int WIDTH = 750;
  public final static int HEIGHT = 657;
  private InternalFrameAction internalFrameAction = new InternalFrameAction();
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private Userdata neuuser;
  private JUser userPane;
  private Class<? extends JUpdateProfilFrame> resource;

  public JUpdateProfilFrame(Userdata user) {
    resource = getClass();
    setFrameIcon(new ImageIcon(resource.getResource(Resource.PERSONAL_16X16)));
    setMaximizable(false);
    setResizable(true);
    setIconifiable(true);
    setClosable(true);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    addInternalFrameListener(internalFrameAction);
    userPane = new JUser(user);
    userPane.addUserListener((event) -> {
      Control rc = (Control) event.getNewValue();
      switch(rc) {
        case SAVE:
          neuuser = userPane.getChangeUser();
          /* musz unbedingt vor setClosed stehen */
          /* setClosed löst event aus */
          changes.firePropertyChange(event);
          break;
        case SAVE_AND_CLOSE:
          neuuser = userPane.getChangeUser();
          /* musz unbedingt vor setClosed stehen */
          /* setClosed löst event aus */
          changes.firePropertyChange(event);
          doDefaultCloseAction();
          break;
        case CLOSE:
          changes.firePropertyChange(event);
          doDefaultCloseAction();
          break;
        default:
          break;
      }

    });
    setContentPane(userPane);
    setMinimumSize(new Dimension(WIDTH - 100, HEIGHT - 80));
    setSize(WIDTH, HEIGHT);
  }



  public void addUserListener(PropertyChangeListener l) {
    changes.addPropertyChangeListener(l);
  }



  public Userdata getChangeUser() {
    return neuuser;
  }



  public boolean isMailWritable() {
    return userPane.isMailWritable();
  }



  public boolean isPasswordWritable() {
    return userPane.isPasswordWritable();
  }



  public void removeAllListener() {
    for (PropertyChangeListener listener : changes.getPropertyChangeListeners()) {
      removeUserListener(listener);
    }
    userPane.removeAllListener();
  }



  public void removeUserListener(PropertyChangeListener l) {
    changes.removePropertyChangeListener(l);
  }



  @Override
  public void setFrameTitleId(String str) {
    setTitle(str);
  }



  @Override
  public void setLanguage(ISO639 code) {
    setLanguage(KEY.FRAME_UPDATE_PROFIL, code);
    userPane.setLanguage(code);
  }



  public void setMailWritable(boolean value) {
    userPane.setMailWritable(value);
  }



  public void setPasswordWritable(boolean value) {
    userPane.setPasswordWritable(value);
  }

  /*****************************************************************************/
  /*                                                                           */
  /* Innerclass InternalFrameAction */
  /*                                                                           */
  /*****************************************************************************/

  class InternalFrameAction extends InternalFrameAdapter {

    @Override
    public void internalFrameActivated(InternalFrameEvent event) {
      userPane.setFocus();
    }



    @Override
    public void internalFrameClosing(InternalFrameEvent event) {
      changes.firePropertyChange(JUpdateProfilFrame.class.getName(), Control.NULL, Control.CLOSE);
    }

  }

  @Override
  public void setBackgroundGradient(Color top, Color bottom) {
    windowManager.setBackgroundGradient(top, bottom);
  }

}
