/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



public class RegistryButton extends JPanel implements Babelfish {

  private static final long serialVersionUID = 4818417888360570711L;
  MultilingualButton buttonRegistrieren = new MultilingualButton();
  MultilingualButton buttonBack = new MultilingualButton();
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private FlowLayout flow = new FlowLayout();
  ActionListener registrierenListener;
  private ActionListener schliessenListener;
  private KEY key;

  public RegistryButton() {
    this(KEY.BUTTON_WEITER_OHNE_REGISTRIERUNG);
  }



  /**
   * Auf dem rechten Knopf soll entweder "Weiter ohne Registrierung" oder "Zurück"
   * erscheinen.
   * 
   * @param button
   *               dieser Schriftzug wird eingeblendet
   */
  public RegistryButton(KEY text) {
    key = text;
    setLayout(flow);
    add(buttonRegistrieren);
    registrierenListener = new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        changes.firePropertyChange(RegistryButton.class.getName(), Control.NULL, Control.REGISTRIEREN);
      }
    };
    schliessenListener = new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        changes.firePropertyChange(RegistryButton.class.getName(), Control.NULL, Control.OHNE_REGISTRIEREN);
      }
    };
    buttonRegistrieren.addActionListener(registrierenListener);
    add(buttonBack);
    buttonBack.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    buttonBack.addActionListener(schliessenListener);

  }



  public void addKnopfListener(PropertyChangeListener paramPropertyChangeListener) {
    changes.addPropertyChangeListener(paramPropertyChangeListener);
  }



  public void hitSign() {
    changes.firePropertyChange(RegistryButton.class.getName(), Control.NULL, Control.REGISTRIEREN);
  }



  public void removeAllKnopfListener() {
    for (PropertyChangeListener tmp : changes.getPropertyChangeListeners()) {
      removeKnopfListener(tmp);
    }
  }



  public void removeAllListener() {
    removeAllKnopfListener();
    buttonBack.removeActionListener(schliessenListener);
    buttonRegistrieren.removeActionListener(registrierenListener);
  }



  public synchronized void removeKnopfListener(PropertyChangeListener paramPropertyChangeListener) {
    changes.removePropertyChangeListener(paramPropertyChangeListener);
  }



  @Override
  public void setLanguage(ISO639 code) {
    buttonRegistrieren.setLanguage(KEY.BUTTON_RIGISTRATE, code);
    buttonBack.setLanguage(key, code);
  }
}
