/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.base;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import net.javacomm.restserver.MessageBodyNickname;
import net.javacomm.share.Constants;



/**
 * Dieser Webservice (Jersey) liest verbotene Nicknames aus.
 */
public class ReadNicknamesWorker extends SwingWorker<List<String>, Void> {

  private String domain;

  /**
   * Webservice initialisieren
   * 
   * @param domain
   *               an diese Domäne wird gesendet
   */
  public ReadNicknamesWorker(String domain) {
    this.domain = domain;
  }



  @Override
  protected List<String> doInBackground() {
    ArrayList<String> result = new ArrayList<>();
    try(Client client = ClientBuilder.newClient()) {
      StringBuilder url = new StringBuilder(Constants.PROTOCOL).append(domain)
          .append("/javacommserver/administrator/read/nicknames");

      client.register(MessageBodyNickname.class);
      WebTarget webtarget = client.target(url.toString());
      GenericType<ArrayList<String>> configType = new GenericType<>() {};
      result = webtarget.request(MediaType.APPLICATION_JSON_TYPE).get(configType);
      return result;
    }
  }
}
