/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.base;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import javax.swing.SwingWorker;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import net.javacomm.restserver.Wrapper;
import net.javacomm.share.Constants;
import net.javacomm.transfer.TransferUser;



public class SaveKontoaktivitaetenWorker extends SwingWorker<Boolean, Void> {

  private String userid;
  private String password;
  private List<TransferUser> userliste;
  private Boolean result;

  public SaveKontoaktivitaetenWorker(String userid, String password, List<TransferUser> userliste) {
    this.userid = userid;
    this.password = password;
    this.userliste = userliste;
  }



  @Override
  protected Boolean doInBackground() throws Exception {
    try(Client client = ClientBuilder.newClient()) {
      client.register(MultiPartFeature.class);
      client.register(MultiPartFeature.class);
      StringBuilder url = new StringBuilder(Constants.PROTOCOL).append(Constants.DOMAIN)
          .append("/javacommserver/administrator/benutzerstatus");
      WebTarget webtarget = client.target(url.toString());
      try(FormDataMultiPart multipart = new FormDataMultiPart()) {
        multipart.field("userid", userid);
        multipart.field("password", password);
        multipart.field("userliste", Wrapper.toString(userliste));

        result = webtarget.request(MediaType.TEXT_PLAIN)
            .post(Entity.entity(multipart, multipart.getMediaType()), Boolean.class);

      }
    }
    return result;
  }



  public void done() {
    if (result) {
      // hier muss eine Erfolgsmeldung kommen
      // Die neuen Benutzeranträge wurden bearbeitet und gespeichert.
    }
    else {
      // hier muss eine Fehlermeldung kommen
      // Die Benutzeranträge wurden nicht gespeichert.
    }
  }

}
