/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.gui;


import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import org.nexuswob.gui.ArrowTooltip;
import org.nexuswob.gui.JToolTipBorder;
import net.javacomm.client.environment.GUI;
import net.javacomm.client.resource.Resource;
import net.javacomm.multilingual.MultilingualString;
import net.javacomm.multilingual.schema.KEY;



/**
 * Ein Zweilistenpanel, über welches Werte hin- und hergeschoben werden können.
 * 
 * @author lromero
 *
 */
public class TresPanelList extends JPanel {

  private static final long serialVersionUID = -9101745604844305853L;

  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private JUserlist teilnehmerlist = new JUserlist();
  private JUserlist neueTeilnehmerlist = new JUserlist();
  private ArrowPanel arrowPanel = new ArrowPanel();
  private JUserlist benutzerlist = new JUserlist();
  private Collection<String> referenceList = new ArrayList<>();

  public TresPanelList() {
    setLayout(gridbag);

    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(0, 0, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(teilnehmerlist, con);
    add(teilnehmerlist);

    con.gridx++;
    con.gridy = 0;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(0, 0, 0, 0);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(neueTeilnehmerlist, con);
    add(neueTeilnehmerlist);

    con.gridx++;
    con.gridy = 0;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(0, 6, 0, 6);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(arrowPanel, con);
    add(arrowPanel);

    con.gridx++;
    con.gridy = 0;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(0, 0, 0, 0);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(benutzerlist, con);
    add(benutzerlist);

  }



  /**
   * Der linke Listenname wird gesetzt.
   * 
   * @param header
   *               die Überschrift
   */
  public void setLeftListName(String header) {
    teilnehmerlist.setHeader(header);
  }



  /**
   * Der mittlere Listenname wird gesetzt.
   * 
   * @param header
   *               die Überschrift
   */
  public void setCenterList(String header) {
    neueTeilnehmerlist.setHeader(header);
  }



  /**
   * Der rechte Listenname wird gesetzt.
   * 
   * @param header
   *               die Überschrift
   */
  public void setRightlistName(String header) {
    benutzerlist.setHeader(header);
  }

  /**
   *
   *
   *
   * @author llange
   *
   */
  private class ArrowPanel extends JPanel {

    private static final long serialVersionUID = 779758453353282377L;
    private MultilingualString teilnehmerEinladen = new MultilingualString(
        KEY.STRING_BENUTZER_IN_DIE_TEILNEHMERLISTE
    );
    private MultilingualString teilnehmerVerabschieden = new MultilingualString(
        KEY.STRING_BENUTZER_AUS_DER_TEILNEHMERLISTE
    );
    @SuppressWarnings("serial")
    private JButton buttonLeft = new JButton() {
      @Override
      public JToolTip createToolTip() {
        ArrowTooltip arrow = new ArrowTooltip(Resource.JQUERY_ORANGE);
        arrow.setComponent(buttonLeft);
        arrow.setTextAttributes(GUI.regularFont13, Color.BLACK, Resource.JQUERY_ORANGE);
        arrow.setBorder(new JToolTipBorder(7, Resource.JQUERY_GREEN, Resource.JQUERY_ORANGE));
        return arrow;
      }
    };
    @SuppressWarnings("serial")
    private JButton buttonRight = new JButton() {
      @Override
      public JToolTip createToolTip() {
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(4000);
        ArrowTooltip arrow = new ArrowTooltip(Resource.JQUERY_ORANGE);
        arrow.setComponent(buttonRight);
        arrow.setTextAttributes(GUI.regularFont13, Color.BLACK, Resource.JQUERY_ORANGE);
        arrow.setBorder(new JToolTipBorder(7, Resource.JQUERY_RED, Resource.JQUERY_ORANGE));
        return arrow;
      }
    };

    private Class<? extends ArrowPanel> clazz;

    private ArrowPanel() {
      super(true);
      setLayout(new GridLayout(2, 1));
      init();
    }



    /**
     * Hat sich die Freundesliste geändert?
     *
     */
    private void changedBuddies() {
      ArrayList<String> collection = Collections.list(neueTeilnehmerlist.getMembers());
      boolean found = collection.size() == referenceList.size();
      for (String tmp : collection) {
        found = found && referenceList.contains(tmp);
      }
      if (found) {
        // TODO event auslösen
//        serviceButton.setDisabledButton1();
      }
      else {
        // TODO event auslösen
//        serviceButton.setEnabledButton1();
      }
    }



    private void init() {
      clazz = getClass();
      buttonLeft.setIcon(new ImageIcon(clazz.getResource(Resource.LEFTARROW_25x26)));
//      buttonLeft.setToolTipText(teilnehmerEinladen.toString());
      buttonLeft.addActionListener(new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent event) {
          List<String> selectedMembers = benutzerlist.getSelectedMembers();
          benutzerlist.removeMember(selectedMembers);
          neueTeilnehmerlist.setMember(selectedMembers);
          changedBuddies();
        }
      });
      buttonRight.setIcon(new ImageIcon(clazz.getResource(Resource.RIGHTARROW_25x26)));
//      buttonRight.setToolTipText(teilnehmerVerabschieden.toString());
      buttonRight.addActionListener(new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent eevnt) {
          List<String> selectedMembers = neueTeilnehmerlist.getSelectedMembers();
          neueTeilnehmerlist.removeMember(selectedMembers);
          benutzerlist.setMember(selectedMembers);
          changedBuddies();
        }
      });

      add(buttonLeft);
      add(buttonRight);
    }

  }

}
