/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.iptv;

/**
 * Wird geworfen, wenn der Player nicht mehr verwendet werden kann. Er ist in
 * Zukunft unbrauchbar.
 */
@SuppressWarnings("serial")
public class EmbeddedPlayerException extends Exception {

  /**
   * Der Player ist unbrauchbar.
   * 
   * @param message
   *                Fehlernachricht
   */
  public EmbeddedPlayerException(String message) {
    super(message);
  }



  /**
   * Der Player ist unbrauchbar.
   * 
   * @param cause
   *              Fehlerursache
   */
  public EmbeddedPlayerException(Throwable cause) {
    super(cause);
  }



  /**
   * Der Player ist unbrauchbar.
   * 
   * @param message
   *                Fehlernachricht
   * @param cause
   *                Fehlerursache
   */
  public EmbeddedPlayerException(String message, Throwable cause) {
    super(message, cause);
  }



  /**
   * Der Player ist unbrauchbar.
   * 
   * @param message
   *                           Fehlernachricht
   * @param cause
   *                           Fehlerursache
   * @param enableSuppression
   * @param writableStackTrace
   *                           Fehlerverfolgung aktivieren oder deaktivieren
   */
  public EmbeddedPlayerException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);
  }

}
