/**
 * Module descriptor added to enable Java Platform Module System (JPMS) support.
 *
 * Original library: jersey-client Copyright (c) 2024 Oracle and/or its
 * affiliates.
 *
 * This file was added by Luis Andrés Lange <https://javacomm.net>, 2025.
 *
 * Licensed under the Eclipse Public License v. 2.0 (EPL-2.0).
 *
 * This file does not modify or replace the licensing terms of the original
 * work.
 */
module org.glassfish.jersey.client {
  requires jakarta.annotation;
  requires java.logging;

  requires transitive jakarta.inject;
  requires transitive jakarta.ws.rs;
  requires transitive org.glassfish.jersey.common;

  exports org.glassfish.jersey.client;
  exports org.glassfish.jersey.client.authentication;
  exports org.glassfish.jersey.client.filter;
  exports org.glassfish.jersey.client.http;
  exports org.glassfish.jersey.client.inject;
  exports org.glassfish.jersey.client.innate;
  exports org.glassfish.jersey.client.innate.http;
  exports org.glassfish.jersey.client.innate.inject;
  exports org.glassfish.jersey.client.internal;
  exports org.glassfish.jersey.client.internal.inject;
  exports org.glassfish.jersey.client.internal.routing;
  exports org.glassfish.jersey.client.spi;

  opens org.glassfish.jersey.client to h2k.locator, org.glassfish.h2k.utils;

  provides jakarta.ws.rs.client.ClientBuilder with org.glassfish.jersey.client.JerseyClientBuilder;

}
