/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

import java.sql.Timestamp;



/**
 * Diese Klasse bildet die Tabelle TB_RECORD ab.
 */
public class Record {

  private String chatid;
  private int number; // sollte long sein, weil in der Datenbank unsigned int; Number ist unbekannt
  // number sollte über UUID_64 gesetzt werden
  private String uid;
  private Long anlage;
  private Timestamp time;
  private String message;

  public Record() {}



  public String getChatid() {
    return chatid;
  }



  public void setChatid(String chatid) {
    this.chatid = chatid;
  }



  public int getNumber() {
    return number;
  }



  public void setNumber(int number) {
    this.number = number;
  }



  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public Long getAnlage() {
    return anlage;
  }



  public void setAnlage(Long anlage) {
    this.anlage = anlage;
  }



  public Timestamp getTime() {
    return time;
  }



  public void setTime(Timestamp time) {
    this.time = time;
  }



  public String getMessage() {
    return message;
  }



  public void setMessage(String message) {
    this.message = message;
  }

}
