/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;


public class JTablePanel extends JPanel {

	private static final long serialVersionUID = -5025714420707495978L;
  private JTable table = new JTable();
  private TableModel3 model = new TableModel3();
  private JScrollPane scroll = new JScrollPane();
  

	public JTablePanel() {
		this(false);
	}

	
	public JTablePanel(boolean isDoubleBuffered) {
		super(isDoubleBuffered);
		init();
	}
	
	
	private void init() {
		
    table.setModel(model);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
    table.setBackground(Color.white);
    table.setForeground(Color.black);
    table.setSelectionBackground(table.getForeground());
    table.setSelectionForeground(table.getBackground());
    table.setShowGrid(true);
    
    
    
    //scroll.setOpaque(true);
    scroll.getViewport().setBackground(Color.WHITE);

		
		// GUI
		setLayout(new BorderLayout(0,0));
		scroll.setViewportView(table);
		
    UIDefaults uidefaults = new UIDefaults();
    uidefaults.put("ScrollPane.contentMargins", new Insets(0,0,0,0));
    scroll.putClientProperty("Nimbus.Overrides", uidefaults);
    scroll.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
    scroll.getVerticalScrollBar().setUnitIncrement(10);
    scroll.getHorizontalScrollBar().setUnitIncrement(10);

		
		this.add(scroll, BorderLayout.CENTER);
	}


	
	public JScrollPane getScrollPane() {
		return scroll;
	}
	
	
	
	public JTable getTable() {
		return table;
	}
	
	
  /**
   * Gib das TableModel zur�ck.
   * 
   * 
   * @return
   */
  public TableModel3 getModel() {
    return (TableModel3)table.getModel();
  }

	
  
 
  
	
}
