/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class MICROERROR extends MESSAGE {

  public final static String FROM_USERID = "FROM_USERID";
  public final static String FROM_NICKNAME = "FROM_NICKNAME";
  public final static String TO_USERID = "TO_USERID";

  
  private String fromUserid;
  private String fromNickname;
  private String toUserid;
  
  
  
  public String getFromUserid() {
    return fromUserid;
  }
  
  
  public void setFromUserid(String fromUserid) {
    this.fromUserid = fromUserid;
  }
  
  
  public String getFromNickname() {
    return fromNickname;
  }
  
  
  public void setFromNickname(String fromNickname) {
    this.fromNickname = fromNickname;
  }
  
  
  public String getToUserid() {
    return toUserid;
  }
  
  
  public void setToUserid(String toUserid) {
    this.toUserid = toUserid;
  }
  
  
}
