/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



/**
 * Die Mausposition auf dem Bildschirm.
 */
public class NEWMOUSEPOINTER extends MESSAGE {

  public final static String X = "X";
  public final static String Y = "Y";

  private Integer x;
  private Integer y;

  public NEWMOUSEPOINTER() {}



  public Integer getX() {
    return x;
  }



  public Integer getY() {
    return y;
  }



  public void setX(Integer x) {
    this.x = x;
  }



  public void setY(Integer y) {
    this.y = y;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(NEWMOUSEPOINTER.class, new NewMousepointerSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
