/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import java.util.regex.Pattern;



/**
 * 
 * Das Applikationsprotokoll zwischen Controller und Portal hat das Format
 * HEADER | COMMAND | DATASET. Das Protokoll sitzt oberhalb von <i>JSON</i>. In
 * der Klasse sind alle Schlüsselwörter als Konstante für die Datenübertragung
 * hinterlegt. Spätere Neuerungen oder Änderungen sind über diese Klasse
 * vorzunehmen.
 * 
 * @author llange
 *
 */
public abstract class Protocol {

  final static Pattern PATTERN_JSON = Pattern.compile("\\{\"HEADER\".+\"COMMAND\".+\\}");
  /**
   * Splittet einen Dateipfadnamen in Pfad und Name auf.
   */
  public final static Pattern PATH_SEPARATOR = Pattern.compile("(.*[\\x5c/])(.+)$");

  /**
   * Ein JSON Key
   */
  public final static String HEADER = "HEADER";
  /**
   * Ein JSON Key
   */
  public final static String DATASET = "DATASET";

  /**
   * Restful Paramternamen
   */

  public final static String KONFERENZRAUM = "KONFERENZRAUM";
  public final static String ORGANISATOR = "ORGANISATOR";
  public final static String SCREENSHOT = "SCREENSHOT";

}
