/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class TRANSFER extends FILETRANSFER {

  public final static String FILENAME = "FILENAME";
  public final static String PATHFILE = "PATHFILE";
  public final static String BLOCKINDEX = "BLOCKINDEX";
  public final static String ENDFLAG = "ENDFLAG";
  public final static String SLOT = "SLOT";
  public final static String PAYLOAD = "PAYLOAD";

  
  
  private String filename;
  private String pathfile;
  private int blockindex;
  private boolean endflag;
  private int slot;
  private String payload;
  
  
  public void setBlockindex(int value) {
    blockindex = value;
  }
  
  
  public void setEndflag(boolean value) {
    endflag = value;
  }
  
  
  /**
   * 
   * @param value der Dateiname ohne Pfadangabe
   */
  public void setFilename(String value) {
    filename = value;
  }
  
  
  
  /**
   * 
   * @param value Nur die Pfadangabe ohne Dateiname
   */
  public void setPathfile(String value) {
    pathfile = value;
  }
  
  
  public void setPayload(String value) {
    payload = value;
  }
  
  
  public void setSlot(int value) {
    slot = value;
  }
  
  
  public int getBlockindex() {
    return blockindex;
  }
  
  
  public boolean getEndflag() {
    return endflag;
  }
  
  
  public String getFilename() {
    return filename;
  }
  
  
  public String getPathfile() {
    return pathfile;
  }
  
  
  public String getPayload() {
    return payload;
  }
  
  
  public int getSlot() {
    return slot;
  }
  
  
}
