/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol.crypto;

/**
 * Wird geworfen, wenn ein Algorithmus oder eine Verschlüsselungsmethode nicht
 * unterstützt wird.
 */
@SuppressWarnings("serial")
public class CryptoException extends RuntimeException {

  /**
   * Die Verschlüsselung oder Entschlüsselung ist nicht möglich.
   * 
   */
  public CryptoException() {}



  /**
   * Die Verschlüsselung oder Entschlüsselung ist nicht möglich.
   * 
   * @param message
   *                diese Fehlerursache
   */
  public CryptoException(String message) {
    super(message);

  }



  /**
   * Die Verschlüsselung oder Entschlüsselung ist nicht möglich.
   * 
   * @param cause
   *              diese Fehlerursache
   */
  public CryptoException(Throwable cause) {
    super(cause);

  }



  /**
   * Die Verschlüsselung oder Entschlüsselung ist nicht möglich.
   * 
   * @param message
   *                diese Fehlerbeschreibung
   * @param cause
   *                diese Fehlerursache
   */
  public CryptoException(String message, Throwable cause) {
    super(message, cause);

  }



  /**
   * Die Verschlüsselung oder Entschlüsselung ist nicht möglich.
   * 
   * 
   * @param message
   *                           diese Fehlerbeschreibung
   * @param cause
   *                           diese Fehlerursache
   * @param enableSuppression
   *                           {@code true}, sammeln vieler Exceptions zum
   *                           Beispiel in try-with-resources
   * @param writableStackTrace
   */
  public CryptoException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);

  }

}
