/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

public enum Sprachguete {

  LOW(4, "8000Hz"),
  MEDIUM_LOW(1, "9600Hz"),
  MEDIUM(3, "16000Hz"),
  HIGH(2, "19200Hz"),
  SUPER_HIGH(5, "44100Hz");

  private int puffer;
  private String beschreibung;

  private Sprachguete(int puffer, String beschreibung) {
    this.puffer = puffer;
    this.beschreibung = beschreibung;
  }



  public int getPuffer() {
    return puffer;
  }



  @Override
  public String toString() {
    return beschreibung;
  }



  public static Sprachguete toSprachguete(int puffer) {
    for (Sprachguete tmp : Sprachguete.values()) {
      if (tmp.getPuffer() == puffer) {
        return tmp;
      }
    }
    throw new IllegalArgumentException();
  }



  public static Sprachguete toSprachguete(String beschreibung) {
    for (Sprachguete tmp : Sprachguete.values()) {
      if (tmp.toString().equals(beschreibung)) {
        return tmp;
      }
    }
    throw new IllegalArgumentException();
  }
}
