/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;



public class TransferChatfile {

  private Long number;
  private String receiverUid;
  private String remoteNickname;
  private String uid;
  private String absoluteFilename;
  private String filename;
  private String message;
  private long filesize;
  private boolean error;

  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }



  public String getReceiverUid() {
    return receiverUid;
  }



  public void setReceiverUid(String receiverUid) {
    this.receiverUid = receiverUid;
  }



  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public String getAbsoluteFilename() {
    return absoluteFilename;
  }



  public void setAbsoluteFilename(String absoluteFilename) {
    this.absoluteFilename = absoluteFilename;
  }



  public String getMessage() {
    return message;
  }



  public void setMessage(String message) {
    this.message = message;
  }



  public long getFilesize() {
    return filesize;
  }



  public void setFilesize(long filesize) {
    this.filesize = filesize;
  }



  public boolean isError() {
    return error;
  }



  public void setError(boolean error) {
    this.error = error;
  }



  public String getFilename() {
    return filename;
  }



  public void setFilename(String filename) {
    this.filename = filename;
  }



  public Long getNumber() {
    return number;
  }



  public void setNumber(Long number) {
    this.number = number;
  }



  public String getRemoteNickname() {
    return remoteNickname;
  }



  public void setRemoteNickname(String remoteNickname) {
    this.remoteNickname = remoteNickname;
  }

}
