/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.ZonedDateTime;
import java.util.TreeMap;



/**
 * Das Transferobjekt übertägt die Maskeninhalte von Telefonkonferenz
 * organisieren.
 *
 * @author lromero
 *
 */
public class TransferOrganizeConferenceCall {

  private String konferenzname; // Konferenzname
  private String beschreibung;
  private TreeMap<String, String> teilnehmer; // alle Teilnehmer (Nickname, UID)
  private ZonedDateTime zonedAblaufdatum;

  public String getKonferenzname() {
    return konferenzname;
  }



  public void setKonferenzname(String konferenzname) {
    this.konferenzname = konferenzname;
  }



  public String getBeschreibung() {
    return beschreibung;
  }



  public void setBeschreibung(String beschreibung) {
    this.beschreibung = beschreibung;
  }



  /**
   *
   * @return n-Paare (Nickname/Userid)
   */
  public TreeMap<String, String> getTeilnehmer() {
    return teilnehmer;
  }



  /**
   * Alle Konferenzteilnehmer werden übergeben.
   *
   * @param teilnehmer
   *                   alle Teilnehmer
   */
  public void setTeilnehmer(TreeMap<String, String> teilnehmer) {
    this.teilnehmer = teilnehmer;
  }




  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(ZonedDateTime.class, new ZonedDateTimeSerializer()).create();
    return gson.toJson(this);
  }



  public ZonedDateTime getZonedAblaufdatum() {
    return zonedAblaufdatum;
  }



  public void setZonedAblaufdatum(ZonedDateTime zonedAblaufdatum) {
    this.zonedAblaufdatum = zonedAblaufdatum;
  }

}
