package net.javacomm.restserver;

import static org.junit.jupiter.api.Assertions.assertEquals;
import java.util.ArrayList;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import net.javacomm.protocol.Benutzerstatus;
import net.javacomm.transfer.TransferRoomfilter;
import net.javacomm.transfer.TransferUser;



public class TestWrapperList {

  @BeforeEach
  public void setUp() {

  }



  @Test
  public void serialize() {

    ArrayList<TransferUser> userliste = new ArrayList<>();

    TransferUser transferuser_1 = new TransferUser();
    transferuser_1.setBenutzerstatus(Benutzerstatus.VOLLMITGLIED.getStatus());
    transferuser_1.setMail("first@mail.com");
    transferuser_1.setUserid("11111111");
    userliste.add(transferuser_1);

    TransferUser transferuser_2 = new TransferUser();
    transferuser_2.setBenutzerstatus(Benutzerstatus.MITGLIEDSCHAFT_ABGELEHNT.getStatus());
    transferuser_2.setMail("second@mail.com");
    transferuser_2.setUserid("22222222");
    userliste.add(transferuser_2);

    String result = userliste.toString();
    assertEquals(
        "[{\"userid\":\"11111111\",\"mail\":\"first@mail.com\",\"benutzerstatus\":1}, {\"userid\":\"22222222\",\"mail\":\"second@mail.com\",\"benutzerstatus\":4}]",
        result
    );

  }



  @Test
  public void deserialize() {
    Wrapper result = Wrapper.fromString(
        "[{\"userid\":\"11111111\",\"mail\":\"first@mail.com\",\"benutzerstatus\":1}, {\"userid\":\"22222222\",\"mail\":\"second@mail.com\",\"benutzerstatus\":4}]"
    );
    assertEquals(2, result.getTransferUser().size());
    for (TransferUser tmp : result.getTransferUser()) {
      System.out.println(tmp.getBenutzerstatus());
      System.out.println(tmp.getMail());
      System.out.println(tmp.getUserid());
      System.out.println("--");
    }
  }



  @Test
  public void deserializeRoomfilter() {
    Wrapper result = Wrapper.fromString(
        "[{\"roomfilter\":\"11111111\",\"mail\":\"first@mail.com\",\"benutzerstatus\":1}, {\"roomfilter\":\"22222222\",\"mail\":\"second@mail.com\",\"benutzerstatus\":4}]"
    );
    assertEquals(2, result.getTransferRoomfilter().size());
    for (TransferRoomfilter tmp : result.getTransferRoomfilter()) {
      System.out.println(tmp.getRoomfilter());
      System.out.println("--");
    }
  }

}
