package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TreeMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



public class TestTransferOrganizeConferenceCall {

  String encoded;
  ZonedDateTime gregor;

  @BeforeEach
  public void setUp() {
    gregor = ZonedDateTime.of(2022, 8, 18, 15, 30, 0, 0, ZoneId.systemDefault());
    encoded = "{\"konferenzname\":\"Dienstag Treff\",\"beschreibung\":\"Wir treffen uns jeden Dienstag\",\"teilnehmer\":{\"anaconda\":\"u2\",\"hexe\":\"u1\",\"jester\":\"u3\"},\"zonedAblaufdatum\":1660829400000}";
  }



  @Test
  public void serialize() {
    TransferOrganizeConferenceCall transfer = new TransferOrganizeConferenceCall();

    transfer.setBeschreibung("Wir treffen uns jeden Dienstag");
    transfer.setKonferenzname("Dienstag Treff");
    TreeMap<String, String> teilnehmer = new TreeMap<>();

    teilnehmer.put("hexe", "u1");
    teilnehmer.put("anaconda", "u2");
    teilnehmer.put("jester", "u3");
    transfer.setTeilnehmer(teilnehmer);

    transfer.setZonedAblaufdatum(gregor);
    assertEquals(encoded, transfer.toString());

  }



  @Test
  public void deserialize() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(ZonedDateTime.class, new ZonedDateTimeDeserializer()).create();
    TransferOrganizeConferenceCall result = gson.fromJson(encoded, TransferOrganizeConferenceCall.class);
    assertEquals("Wir treffen uns jeden Dienstag", result.getBeschreibung());
    assertEquals("Dienstag Treff", result.getKonferenzname());
    TreeMap<String, String> teilnehmer = result.getTeilnehmer();

    assertEquals(teilnehmer.firstKey(), "anaconda");
    assertEquals(teilnehmer.lastKey(), "jester");
    assertTrue(teilnehmer.containsKey("hexe"));
    assertEquals(gregor, result.getZonedAblaufdatum());
  }

}
